/**
* \file: UspiInputSourceImpl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
*          P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_USPI_INPUT_SOURCE_IMPL_H
#define AAUTO_USPI_INPUT_SOURCE_IMPL_H

#include <map>
#include <memory>
#include <aauto/InputSource.h>
#include <uspi/ITouchFacade.h>
#include <uspi/ConfigHandle.h>
#include <aauto/AditInputSource.h>

namespace adit { namespace aauto {

class InputSourceConfig : public uspi::ConfigHandle
{
public:
bool ResultConfig()
{
    bool isValid = true;

    displayWidth = getInt("display-width", &isValid, Range(-1, INT_MAX));
    displayHeight = getInt("display-height", &isValid, Range(-1, INT_MAX));
    verbose = getInt("enable-verbose-logging", &isValid, Range(0, 1), 0);

    return isValid;
}
    int displayWidth;   // Width for Touch Device
    int displayHeight;  // Height for Touch Device
    int verbose;        // Flag for detailed log data
};

class UspiInputSourceImpl : public IInputSourceCallbacks, public uspi::ITouchFacadeCallbacks
{
public:
    UspiInputSourceImpl(InputSource* inInputSource, void* inSessionContext);
    ~UspiInputSourceImpl();
    bool init();
    bool shutdown();
    void setConfigItem(std::string inKey, std::string inValue);
    void registerCallbacks(IAditInputSourceCallbacks* inCallbacks);

protected:
    // IInputSourceCallbacks
    void onInputFeedback(const InputFeedback& inFeedback);

    // ITouchFacadeCallbacks
    void onTouch(uspi::TouchEvent inEvent);
    void onTouchError(int inError);
    void onLogging(uspi::UspiLogLevel inLogLevel, const std::string& inLogString);
    void onLateResolutionData(int inWidth, int inHeight, int inMarginX, int inMarginY);

private:
    bool notifyTouch(int inActionType, int inFingerIndex);

    InputSource* mInputSource;

    void* mSessionContext;
    InputSourceConfig mConfig;
    IAditInputSourceCallbacks* mCallbacks;

    struct Coordinates{ int xPixel; int yPixel;};
    std::map<int,Coordinates> mDownFingers;

    std::unique_ptr<uspi::ITouchFacade> mTouchFacade;
    int mMarginX ;
    int mMarginY ;
    bool mRunning;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_USPI_INPUT_SOURCE_IMPL_H */
